/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bitpack;

import java.io.IOException;
import org.apache.cassandra.index.sai.disk.io.IndexFileUtils;
import org.apache.cassandra.index.sai.disk.io.IndexInputReader;
import org.apache.cassandra.index.sai.disk.v1.DirectReaders;
import org.apache.cassandra.index.sai.disk.v1.LongArray;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.bitpack.AbstractBlockPackedReader;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesMeta;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.PackedLongValues;

public class MonotonicBlockPackedReader
implements LongArray.Factory {
    private final FileHandle file;
    private final int blockShift;
    private final int blockMask;
    private final long valueCount;
    private final byte[] blockBitsPerValue;
    private final PackedLongValues blockOffsets;
    private final PackedLongValues minValues;
    private final float[] averages;

    public MonotonicBlockPackedReader(FileHandle file, NumericValuesMeta meta) throws IOException {
        this.valueCount = meta.valueCount;
        this.blockShift = SAICodecUtils.checkBlockSize(meta.blockSize, 64, 0x8000000);
        this.blockMask = meta.blockSize - 1;
        int numBlocks = SAICodecUtils.numBlocks(this.valueCount, meta.blockSize);
        PackedLongValues.Builder minValuesBuilder = PackedLongValues.monotonicBuilder((float)0.0f);
        PackedLongValues.Builder blockOffsetsBuilder = PackedLongValues.monotonicBuilder((float)0.0f);
        this.averages = new float[numBlocks];
        this.blockBitsPerValue = new byte[numBlocks];
        this.file = file;
        try (RandomAccessReader reader = this.file.createReader();
             IndexInputReader in = IndexInputReader.create(reader);){
            SAICodecUtils.validate(in);
            in.seek(meta.blockMetaOffset);
            for (int i = 0; i < numBlocks; ++i) {
                minValuesBuilder.add(in.readZLong());
                this.averages[i] = Float.intBitsToFloat(in.readInt());
                int bitsPerValue = in.readVInt();
                DirectReaders.checkBitsPerValue(bitsPerValue, in, () -> "Postings list header");
                this.blockBitsPerValue[i] = (byte)bitsPerValue;
                blockOffsetsBuilder.add(bitsPerValue == 0 ? -1L : in.readVLong());
            }
        }
        this.blockOffsets = blockOffsetsBuilder.build();
        this.minValues = minValuesBuilder.build();
    }

    @Override
    public LongArray open() {
        final IndexInput indexInput = IndexFileUtils.instance.openInput(this.file);
        return new AbstractBlockPackedReader(indexInput, this.blockBitsPerValue, this.blockShift, this.blockMask, this.valueCount){

            @Override
            long delta(int block, int idx) {
                return MonotonicBlockPackedReader.expected(MonotonicBlockPackedReader.this.minValues.get((long)block), MonotonicBlockPackedReader.this.averages[block], idx);
            }

            @Override
            public void close() throws IOException {
                indexInput.close();
            }

            @Override
            protected long blockOffsetAt(int block) {
                return MonotonicBlockPackedReader.this.blockOffsets.get((long)block);
            }

            @Override
            public long indexOf(long value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static long expected(long origin, float average, int index) {
        return origin + (long)(average * (float)index);
    }
}

