/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.util.Comparator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.ColumnMetadata;

final class ColumnMetadataVersionComparator
implements Comparator<ColumnMetadata> {
    public static final Comparator<ColumnMetadata> INSTANCE = new ColumnMetadataVersionComparator();

    private ColumnMetadataVersionComparator() {
    }

    @Override
    public int compare(ColumnMetadata v1, ColumnMetadata v2) {
        assert (v1.ksName.equals(v2.ksName) && v1.cfName.equals(v2.cfName) && v1.name.equals(v2.name)) : v1.debugString() + " != " + v2.debugString();
        AbstractType v1Type = v1.type;
        AbstractType v2Type = v2.type;
        if (v1Type.equals(v2Type)) {
            return 0;
        }
        if (v1Type.isValueCompatibleWith(v2Type)) {
            return v2Type.isValueCompatibleWith(v1Type) ? 0 : 1;
        }
        if (v2Type.isValueCompatibleWith(v1Type)) {
            return -1;
        }
        throw new IllegalArgumentException(String.format("Found 2 incompatible versions of column %s in %s.%s: one of type %s and one of type %s (but both types are incompatible)", v1.name, v1.ksName, v1.cfName, v1Type, v2Type));
    }
}

