/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.converter;

import java.util.Arrays;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.LongConverter;

public class PowerOfTwoLongConverter
implements LongConverter {
    private final int shift;
    private final int mask;
    private final short[] encode;
    private final char[] decode;
    private final int maxParseLength;

    public PowerOfTwoLongConverter(String symbols) {
        int length = symbols.length();
        assert (Maths.isPowerOf2((long)length));
        this.shift = Maths.intLog2((long)length);
        this.mask = (1 << this.shift) - 1;
        this.decode = symbols.toCharArray();
        this.encode = new short[128];
        Arrays.fill(this.encode, (short)-1);
        for (int i = 0; i < this.decode.length; ++i) {
            this.encode[this.decode[i]] = (short)i;
        }
        this.maxParseLength = LongConverter.maxParseLength(length);
    }

    @Override
    public int maxParseLength() {
        return this.maxParseLength;
    }

    @Override
    public long parse(CharSequence text) {
        this.lengthCheck(text);
        long v = 0L;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch >= this.encode.length || this.encode[ch] < 0) {
                throw new IllegalArgumentException("Unexpected character '" + ch + "' in \"" + text + "\"");
            }
            v = (v << this.shift) + (long)this.encode[ch];
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int start = text.length();
        while (value != 0L) {
            int val = (int)(value & (long)this.mask);
            text.append(this.decode[val]);
            value >>>= this.shift;
        }
        StringUtils.reverse((StringBuilder)text, (int)start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.setLength(start + this.maxParseLength());
        }
    }

    @Override
    public void append(Bytes<?> text, long value) {
        int start = text.length();
        while (value != 0L) {
            int val = (int)(value & (long)this.mask);
            text.append(this.decode[val]);
            value >>>= this.shift;
        }
        BytesUtil.reverse(text, (int)start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.readLimit((long)start + (long)this.maxParseLength());
        }
    }

    @Override
    public void addEncode(char alias, char as) {
        this.encode[alias] = this.encode[as];
    }
}

