/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Post Quantum Cryptography Signature and Verification component.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface PQCEndpointBuilderFactory {

    /**
     * Builder for endpoint for the PQC Algorithms component.
     */
    public interface PQCEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedPQCEndpointBuilder advanced() {
            return (AdvancedPQCEndpointBuilder) this;
        }

        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.pqc.PQCOperations</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default PQCEndpointBuilder operation(org.apache.camel.component.pqc.PQCOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.pqc.PQCOperations</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default PQCEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the PQC Algorithms component.
     */
    public interface AdvancedPQCEndpointBuilder
            extends
                EndpointProducerBuilder {
        default PQCEndpointBuilder basic() {
            return (PQCEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * In case there is no keyGenerator, we specify an algorithm to build
         * the KeyGenerator.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param keyEncapsulationAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder keyEncapsulationAlgorithm(String keyEncapsulationAlgorithm) {
            doSetProperty("keyEncapsulationAlgorithm", keyEncapsulationAlgorithm);
            return this;
        }
        /**
         * The Key Generator to be used in encapsulation and extraction.
         * 
         * The option is a: <code>javax.crypto.KeyGenerator</code> type.
         * 
         * Group: advanced
         * 
         * @param keyGenerator the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder keyGenerator(javax.crypto.KeyGenerator keyGenerator) {
            doSetProperty("keyGenerator", keyGenerator);
            return this;
        }
        /**
         * The Key Generator to be used in encapsulation and extraction.
         * 
         * The option will be converted to a
         * <code>javax.crypto.KeyGenerator</code> type.
         * 
         * Group: advanced
         * 
         * @param keyGenerator the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder keyGenerator(String keyGenerator) {
            doSetProperty("keyGenerator", keyGenerator);
            return this;
        }
        /**
         * The KeyPair to be used.
         * 
         * The option is a: <code>java.security.KeyPair</code> type.
         * 
         * Group: advanced
         * 
         * @param keyPair the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder keyPair(java.security.KeyPair keyPair) {
            doSetProperty("keyPair", keyPair);
            return this;
        }
        /**
         * The KeyPair to be used.
         * 
         * The option will be converted to a <code>java.security.KeyPair</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param keyPair the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder keyPair(String keyPair) {
            doSetProperty("keyPair", keyPair);
            return this;
        }
        /**
         * A KeyPair alias to use in combination with KeyStore parameter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param keyPairAlias the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder keyPairAlias(String keyPairAlias) {
            doSetProperty("keyPairAlias", keyPairAlias);
            return this;
        }
        /**
         * A KeyStore where we could get Cryptographic material.
         * 
         * The option is a: <code>java.security.KeyStore</code> type.
         * 
         * Group: advanced
         * 
         * @param keyStore the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder keyStore(java.security.KeyStore keyStore) {
            doSetProperty("keyStore", keyStore);
            return this;
        }
        /**
         * A KeyStore where we could get Cryptographic material.
         * 
         * The option will be converted to a <code>java.security.KeyStore</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param keyStore the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder keyStore(String keyStore) {
            doSetProperty("keyStore", keyStore);
            return this;
        }
        /**
         * The KeyStore password to use in combination with KeyStore Parameter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param keyStorePassword the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder keyStorePassword(String keyStorePassword) {
            doSetProperty("keyStorePassword", keyStorePassword);
            return this;
        }
        /**
         * In case there is no signer, we specify an algorithm to build the
         * KeyPair or the Signer.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param signatureAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder signatureAlgorithm(String signatureAlgorithm) {
            doSetProperty("signatureAlgorithm", signatureAlgorithm);
            return this;
        }
        /**
         * The Signer to be used.
         * 
         * The option is a: <code>java.security.Signature</code> type.
         * 
         * Group: advanced
         * 
         * @param signer the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder signer(java.security.Signature signer) {
            doSetProperty("signer", signer);
            return this;
        }
        /**
         * The Signer to be used.
         * 
         * The option will be converted to a
         * <code>java.security.Signature</code> type.
         * 
         * Group: advanced
         * 
         * @param signer the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder signer(String signer) {
            doSetProperty("signer", signer);
            return this;
        }
        /**
         * In the context of extractSecretKeyFromEncapsulation operation, this
         * option define if we want to have the key set as header.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param storeExtractedSecretKeyAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder storeExtractedSecretKeyAsHeader(boolean storeExtractedSecretKeyAsHeader) {
            doSetProperty("storeExtractedSecretKeyAsHeader", storeExtractedSecretKeyAsHeader);
            return this;
        }
        /**
         * In the context of extractSecretKeyFromEncapsulation operation, this
         * option define if we want to have the key set as header.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param storeExtractedSecretKeyAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder storeExtractedSecretKeyAsHeader(String storeExtractedSecretKeyAsHeader) {
            doSetProperty("storeExtractedSecretKeyAsHeader", storeExtractedSecretKeyAsHeader);
            return this;
        }
        /**
         * In case we are using KEM operations, we need a Symmetric algorithm to
         * be defined for the flow to work.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param symmetricKeyAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder symmetricKeyAlgorithm(String symmetricKeyAlgorithm) {
            doSetProperty("symmetricKeyAlgorithm", symmetricKeyAlgorithm);
            return this;
        }
        /**
         * The required length of the symmetric key used.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 128
         * Group: advanced
         * 
         * @param symmetricKeyLength the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder symmetricKeyLength(int symmetricKeyLength) {
            doSetProperty("symmetricKeyLength", symmetricKeyLength);
            return this;
        }
        /**
         * The required length of the symmetric key used.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 128
         * Group: advanced
         * 
         * @param symmetricKeyLength the value to set
         * @return the dsl builder
         */
        default AdvancedPQCEndpointBuilder symmetricKeyLength(String symmetricKeyLength) {
            doSetProperty("symmetricKeyLength", symmetricKeyLength);
            return this;
        }
    }

    public interface PQCBuilders {
        /**
         * PQC Algorithms (camel-pqc)
         * Post Quantum Cryptography Signature and Verification component.
         * 
         * Category: security
         * Since: 4.12
         * Maven coordinates: org.apache.camel:camel-pqc
         * 
         * @return the dsl builder for the headers' name.
         */
        default PQCHeaderNameBuilder pqc() {
            return PQCHeaderNameBuilder.INSTANCE;
        }
        /**
         * PQC Algorithms (camel-pqc)
         * Post Quantum Cryptography Signature and Verification component.
         * 
         * Category: security
         * Since: 4.12
         * Maven coordinates: org.apache.camel:camel-pqc
         * 
         * Syntax: <code>pqc:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default PQCEndpointBuilder pqc(String path) {
            return PQCEndpointBuilderFactory.endpointBuilder("pqc", path);
        }
        /**
         * PQC Algorithms (camel-pqc)
         * Post Quantum Cryptography Signature and Verification component.
         * 
         * Category: security
         * Since: 4.12
         * Maven coordinates: org.apache.camel:camel-pqc
         * 
         * Syntax: <code>pqc:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default PQCEndpointBuilder pqc(String componentName, String path) {
            return PQCEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the PQC Algorithms component.
     */
    public static class PQCHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final PQCHeaderNameBuilder INSTANCE = new PQCHeaderNameBuilder();

        /**
         * The operation we want to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PQCOperation}.
         */
        public String pQCOperation() {
            return "CamelPQCOperation";
        }
        /**
         * The signature of a body.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PQCSignature}.
         */
        public String pQCSignature() {
            return "CamelPQCSignature";
        }
        /**
         * The result of verification of a Body signature.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PQCVerification}.
         */
        public String pQCVerification() {
            return "CamelPQCVerification";
        }
        /**
         * The extracted key in case of extractSecretKeyFromEncapsulation
         * operation and storeExtractedSecretKeyAsHeader option enabled.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PQCSecretKey}.
         */
        public String pQCSecretKey() {
            return "CamelPQCSecretKey";
        }
    }
    static PQCEndpointBuilder endpointBuilder(String componentName, String path) {
        class PQCEndpointBuilderImpl extends AbstractEndpointBuilder implements PQCEndpointBuilder, AdvancedPQCEndpointBuilder {
            public PQCEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new PQCEndpointBuilderImpl(path);
    }
}