/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.solr.SolrComponent;

/**
 * Perform operations against Apache Lucene Solr.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface SolrComponentBuilderFactory {

    /**
     * Solr (camel-solr)
     * Perform operations against Apache Lucene Solr.
     * 
     * Category: search,monitoring
     * Since: 4.8
     * Maven coordinates: org.apache.camel:camel-solr
     * 
     * @return the dsl builder
     */
    static SolrComponentBuilder solr() {
        return new SolrComponentBuilderImpl();
    }

    /**
     * Builder for the Solr component.
     */
    interface SolrComponentBuilder extends ComponentBuilder<SolrComponent> {
    
        
        /**
         * The time in ms to wait before connection will time out.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: producer
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder connectionTimeout(long connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
    
        /**
         * Solr default collection name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param defaultCollection the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder defaultCollection(java.lang.String defaultCollection) {
            doSetProperty("defaultCollection", defaultCollection);
            return this;
        }
    
        /**
         * The solr instance host name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder host(java.lang.String host) {
            doSetProperty("host", host);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * The solr instance port number.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder port(int port) {
            doSetProperty("port", port);
            return this;
        }
    
        
        /**
         * The timeout in ms to wait before the socket will time out.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 600000
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder requestTimeout(long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * To use an existing configured solr client, instead of creating a
         * client per endpoint. This allows customizing the client with specific
         * advanced settings.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.solr.client.solrj.SolrClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param solrClient the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder solrClient(org.apache.solr.client.solrj.SolrClient solrClient) {
            doSetProperty("solrClient", solrClient);
            return this;
        }
    
        
        /**
         * Enable SSL.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param enableSSL the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder enableSSL(boolean enableSSL) {
            doSetProperty("enableSSL", enableSSL);
            return this;
        }
    
        /**
         * Password for authenticating.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder password(java.lang.String password) {
            doSetProperty("password", password);
            return this;
        }
    
        /**
         * Basic authenticate user.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default SolrComponentBuilder username(java.lang.String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    class SolrComponentBuilderImpl
            extends AbstractComponentBuilder<SolrComponent>
            implements SolrComponentBuilder {
        @Override
        protected SolrComponent buildConcreteComponent() {
            return new SolrComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "connectionTimeout": ((SolrComponent) component).setConnectionTimeout((long) value); return true;
            case "defaultCollection": ((SolrComponent) component).setDefaultCollection((java.lang.String) value); return true;
            case "host": ((SolrComponent) component).setHost((java.lang.String) value); return true;
            case "lazyStartProducer": ((SolrComponent) component).setLazyStartProducer((boolean) value); return true;
            case "port": ((SolrComponent) component).setPort((int) value); return true;
            case "requestTimeout": ((SolrComponent) component).setRequestTimeout((long) value); return true;
            case "autowiredEnabled": ((SolrComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "solrClient": ((SolrComponent) component).setSolrClient((org.apache.solr.client.solrj.SolrClient) value); return true;
            case "enableSSL": ((SolrComponent) component).setEnableSSL((boolean) value); return true;
            case "password": ((SolrComponent) component).setPassword((java.lang.String) value); return true;
            case "username": ((SolrComponent) component).setUsername((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}