/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class BookieServiceInfo {
    public static final BookieServiceInfo EMPTY = new BookieServiceInfo(Collections.emptyMap(), Collections.emptyList());
    public static final Supplier<BookieServiceInfo> NO_INFO = () -> EMPTY;
    private Map<String, String> properties;
    private List<Endpoint> endpoints;

    public BookieServiceInfo(Map<String, String> properties, List<Endpoint> endpoints) {
        this.properties = Collections.unmodifiableMap(properties);
        this.endpoints = Collections.unmodifiableList(endpoints);
    }

    public BookieServiceInfo() {
        this(Collections.emptyMap(), Collections.emptyList());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BookieServiceInfo)) {
            return false;
        }
        BookieServiceInfo that = (BookieServiceInfo)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.endpoints, that.endpoints);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.endpoints);
    }

    public String toString() {
        return "BookieServiceInfo{properties=" + this.properties + ", endpoints=" + this.endpoints + '}';
    }

    public static final class Endpoint {
        private String id;
        private int port;
        private String host;
        private String protocol;
        private List<String> auth;
        private List<String> extensions;

        public Endpoint(String id, int port, String host, String protocol, List<String> auth, List<String> extensions) {
            this.id = id;
            this.port = port;
            this.host = host;
            this.protocol = protocol;
            this.auth = auth;
            this.extensions = extensions;
        }

        public Endpoint() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public List<String> getAuth() {
            return this.auth;
        }

        public void setAuth(List<String> auth) {
            this.auth = auth;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List<String> extensions) {
            this.extensions = extensions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Endpoint)) {
                return false;
            }
            Endpoint endpoint = (Endpoint)o;
            return this.port == endpoint.port && Objects.equals(this.id, endpoint.id) && Objects.equals(this.host, endpoint.host) && Objects.equals(this.protocol, endpoint.protocol) && Objects.equals(this.auth, endpoint.auth) && Objects.equals(this.extensions, endpoint.extensions);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.port, this.host, this.protocol, this.auth, this.extensions);
        }

        public String toString() {
            return "EndpointInfo{id=" + this.id + ", port=" + this.port + ", host=" + this.host + ", protocol=" + this.protocol + ", auth=" + this.auth + ", extensions=" + this.extensions + '}';
        }
    }
}

