/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.XAJMSContext;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionForContext;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionForContextImpl;
import org.apache.activemq.artemis.ra.ActiveMQRABundle;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionRequestInfo;
import org.apache.activemq.artemis.ra.ActiveMQRAJMSContext;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.apache.activemq.artemis.ra.ActiveMQRASessionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAXAJMSContext;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActiveMQRASessionFactoryImpl
extends ActiveMQConnectionForContextImpl
implements ActiveMQRASessionFactory,
ActiveMQConnectionForContext,
Referenceable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean closed = false;
    private Reference reference;
    private String userName;
    private String password;
    private String clientID;
    private final int type;
    private boolean started = false;
    private final ActiveMQRAManagedConnectionFactory mcf;
    private final TransactionSynchronizationRegistry tsr;
    private ConnectionManager cm;
    private final Set<ActiveMQRASession> sessions = new HashSet<ActiveMQRASession>();
    private final Set<TemporaryQueue> tempQueues = new HashSet<TemporaryQueue>();
    private final Set<TemporaryTopic> tempTopics = new HashSet<TemporaryTopic>();

    public ActiveMQRASessionFactoryImpl(ActiveMQRAManagedConnectionFactory mcf, ConnectionManager cm, TransactionSynchronizationRegistry tsr, int type) {
        this.mcf = mcf;
        this.tsr = tsr;
        this.cm = cm == null ? new ActiveMQRAConnectionManager() : cm;
        this.type = type;
        if (logger.isTraceEnabled()) {
            logger.trace("constructor({}, {}, {})", new Object[]{mcf, cm, type});
        }
    }

    public JMSContext createContext(int sessionMode) {
        boolean inJtaTx = this.inJtaTransaction();
        int sessionModeToUse = switch (sessionMode) {
            case 1, 3, 100, 101 -> sessionMode;
            case 2 -> {
                if (!inJtaTx) {
                    throw ActiveMQRABundle.BUNDLE.invalidSessionTransactedModeRuntime();
                }
                yield 1;
            }
            case 0 -> {
                if (!inJtaTx) {
                    throw ActiveMQRABundle.BUNDLE.invalidClientAcknowledgeModeRuntime();
                }
                yield 1;
            }
            default -> throw ActiveMQRABundle.BUNDLE.invalidAcknowledgeMode(sessionMode);
        };
        this.incrementRefCounter();
        return new ActiveMQRAJMSContext(this, sessionModeToUse, this.threadAwareContext);
    }

    public XAJMSContext createXAContext() {
        this.incrementRefCounter();
        return new ActiveMQRAXAJMSContext(this, this.threadAwareContext);
    }

    public void setReference(Reference reference) {
        logger.trace("setReference({})", (Object)reference);
        this.reference = reference;
    }

    public Reference getReference() {
        logger.trace("getReference()");
        return this.reference;
    }

    public void setUserName(String name) {
        logger.trace("setUserName({})", (Object)name);
        this.userName = name;
    }

    public void setPassword(String password) {
        logger.trace("setPassword(****)");
        this.password = password;
    }

    public String getClientID() throws JMSException {
        logger.trace("getClientID()");
        this.checkClosed();
        if (this.clientID == null) {
            return ((ActiveMQResourceAdapter)this.mcf.getResourceAdapter()).getProperties().getClientID();
        }
        return this.clientID;
    }

    public void setClientID(String cID) throws JMSException {
        logger.trace("setClientID({})", (Object)cID);
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createQueueSession({}, {})", (Object)transacted, (Object)acknowledgeMode);
        }
        this.checkClosed();
        if (this.type == 2 || this.type == 5) {
            throw new IllegalStateException("Can not get a queue session from a topic connection");
        }
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        logger.trace("createXAQueueSession()");
        this.checkClosed();
        if (this.type == 0 || this.type == 2 || this.type == 5) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(this.type);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createConnectionConsumer({}, {}, {}, {})", new Object[]{queue, messageSelector, sessionPool, maxMessages});
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createTopicSession({}, {})", (Object)transacted, (Object)acknowledgeMode);
        }
        this.checkClosed();
        if (this.type == 1 || this.type == 4) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        logger.trace("createXATopicSession()");
        this.checkClosed();
        if (this.type == 0 || this.type == 1 || this.type == 4) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(this.type);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createConnectionConsumer({}, {}, {}, {})", new Object[]{topic, messageSelector, sessionPool, maxMessages});
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createConnectionConsumer({}, {}, {}, {}, {})", new Object[]{topic, subscriptionName, messageSelector, sessionPool, maxMessages});
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, ServerSessionPool pool, int maxMessages) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createConnectionConsumer({}, {}, {})", new Object[]{destination, pool, maxMessages});
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String name, ServerSessionPool pool, int maxMessages) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createConnectionConsumer({}, {}, {}, {})", new Object[]{destination, name, pool, maxMessages});
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createSession({}, {})", (Object)transacted, (Object)acknowledgeMode);
        }
        this.checkClosed();
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public XASession createXASession() throws JMSException {
        logger.trace("createXASession()");
        this.checkClosed();
        return this.allocateConnection(this.type);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        logger.trace("getMetaData()");
        this.checkClosed();
        return this.mcf.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        logger.trace("getExceptionListener()");
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        logger.trace("setExceptionListener({})", (Object)listener);
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.checkClosed();
        logger.trace("start() {}", (Object)this);
        Set<ActiveMQRASession> set = this.sessions;
        synchronized (set) {
            if (this.started) {
                return;
            }
            this.started = true;
            for (ActiveMQRASession session : this.sessions) {
                session.start();
            }
        }
    }

    public void stop() throws JMSException {
        logger.trace("stop() {}", (Object)this);
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        TemporaryQueue temp;
        Iterator<Object> i;
        logger.trace("close() {}", (Object)this);
        if (this.closed) {
            return;
        }
        this.closed = true;
        Set<Object> set = this.tempQueues;
        synchronized (set) {
            i = this.tempQueues.iterator();
            while (i.hasNext()) {
                temp = i.next();
                try {
                    logger.trace("Closing temporary queue {} for {}", (Object)temp, (Object)this);
                    temp.delete();
                }
                catch (Throwable t) {
                    logger.trace("Error deleting temporary queue", t);
                }
                i.remove();
            }
        }
        set = this.tempTopics;
        synchronized (set) {
            i = this.tempTopics.iterator();
            while (i.hasNext()) {
                temp = (TemporaryTopic)i.next();
                try {
                    logger.trace("Closing temporary topic {} for {}", (Object)temp, (Object)this);
                    temp.delete();
                }
                catch (Throwable t) {
                    logger.trace("Error deleting temporary queue", t);
                }
                i.remove();
            }
        }
        set = this.sessions;
        synchronized (set) {
            i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQRASession session = (ActiveMQRASession)i.next();
                try {
                    session.closeSession();
                }
                catch (Throwable t) {
                    logger.trace("Error closing session", t);
                }
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession(ActiveMQRASession session) throws JMSException {
        logger.trace("closeSession({})", (Object)session);
        Set<ActiveMQRASession> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTemporaryQueue(TemporaryQueue temp) {
        logger.trace("addTemporaryQueue({})", (Object)temp);
        Set<TemporaryQueue> set = this.tempQueues;
        synchronized (set) {
            this.tempQueues.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTemporaryTopic(TemporaryTopic temp) {
        logger.trace("addTemporaryTopic({})", (Object)temp);
        Set<TemporaryTopic> set = this.tempTopics;
        synchronized (set) {
            this.tempTopics.add(temp);
        }
    }

    public Session createSession(int sessionMode) throws JMSException {
        return this.createSession(sessionMode == 0, sessionMode);
    }

    public Session createSession() throws JMSException {
        return this.createSession(1);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createSharedConnectionConsumer({}, {}, {}, {}, {})", new Object[]{topic, subscriptionName, messageSelector, sessionPool, maxMessages});
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("createSharedDurableConnectionConsumer({}, {}, {}, {}, {})", new Object[]{topic, subscriptionName, messageSelector, sessionPool, maxMessages});
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    protected ActiveMQRASession allocateConnection(int sessionType) throws JMSException {
        return this.allocateConnection(false, 1, sessionType);
    }

    protected ActiveMQRASession allocateConnection(boolean transacted, int acknowledgeMode, int sessionType) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("allocateConnection({}, {}, {})", new Object[]{transacted, acknowledgeMode, sessionType});
        }
        try {
            Set<ActiveMQRASession> set = this.sessions;
            synchronized (set) {
                if (!this.sessions.isEmpty()) {
                    throw new IllegalStateException("Only allowed one session per connection. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
                }
                if (!this.mcf.isIgnoreJTA() && (this.inJtaTransaction() || this.mcf.isInJtaTransaction().booleanValue())) {
                    transacted = true;
                    acknowledgeMode = 0;
                } else if (transacted && this.mcf.isAllowLocalTransactions().booleanValue()) {
                    acknowledgeMode = 0;
                } else {
                    transacted = false;
                    switch (acknowledgeMode) {
                        case 1: 
                        case 3: 
                        case 100: 
                        case 101: {
                            break;
                        }
                        case 2: {
                            throw ActiveMQRABundle.BUNDLE.invalidClientAcknowledgeModeRuntime();
                        }
                        case 0: {
                            if (!this.mcf.isAllowLocalTransactions().booleanValue()) {
                                throw ActiveMQRABundle.BUNDLE.invalidSessionTransactedModeRuntimeAllowLocal();
                            }
                            transacted = true;
                            break;
                        }
                        default: {
                            throw ActiveMQRABundle.BUNDLE.invalidAcknowledgeMode(acknowledgeMode);
                        }
                    }
                }
                ActiveMQRAConnectionRequestInfo info = new ActiveMQRAConnectionRequestInfo(transacted, acknowledgeMode, sessionType);
                info.setUserName(this.userName);
                info.setPassword(this.password);
                info.setClientID(this.clientID);
                info.setDefaults(((ActiveMQResourceAdapter)this.mcf.getResourceAdapter()).getProperties());
                logger.trace("Allocating session for {} with request info={}", (Object)this, (Object)info);
                ActiveMQRASession session = (ActiveMQRASession)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)info);
                try {
                    logger.trace("Allocated  {} session={}", (Object)this, (Object)session);
                    session.setActiveMQSessionFactory(this);
                    if (this.started) {
                        session.start();
                    }
                    this.sessions.add(session);
                    return session;
                }
                catch (Throwable t) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (t instanceof Exception) {
                        Exception exception = (Exception)t;
                        throw exception;
                    }
                    throw new RuntimeException("Unexpected error: ", t);
                }
            }
        }
        catch (Exception e) {
            Throwable current;
            for (current = e; current != null && !(current instanceof JMSException); current = current.getCause()) {
            }
            if (current != null && current instanceof JMSException) {
                JMSException jmsException = (JMSException)current;
                throw jmsException;
            }
            JMSException je = new JMSException("Could not create a session: " + e.getMessage());
            je.setLinkedException(e);
            je.initCause((Throwable)e);
            throw je;
        }
    }

    protected void checkClosed() throws IllegalStateException {
        logger.trace("checkClosed() {}", (Object)this);
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
    }

    private boolean inJtaTransaction() {
        boolean inJtaTx = false;
        if (this.tsr != null) {
            inJtaTx = this.tsr.getTransactionStatus() != 6;
        }
        return inJtaTx;
    }
}

